<?php
// auth.php
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) session_start();

function require_company(): void {
  if (empty($_SESSION['company_id'])) {
    header('Location: login_company.php'); exit;
  }
}

function require_motoboy(): void {
  if (empty($_SESSION['motoboy_id'])) {
    header('Location: login_motoboy.php'); exit;
  }
}

function h(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}
