<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];

$st = $pdo->prepare("
  SELECT d.*, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.company_id = ?
  ORDER BY d.id DESC
  LIMIT 10
");
$st->execute([$companyId]);
$deliveries = $st->fetchAll();

render_header('Empresa - Dashboard');
?>
<div class="grid grid-2">
  <div class="card">
    <h1>Olá, <?= h((string)$_SESSION['company_name']) ?></h1>
    <p class="small">Crie uma nova solicitação e acompanhe o andamento em tempo real (SSE).</p>
    <div style="display:flex; gap:10px; flex-wrap:wrap;">
      <a class="btn btn-primary" href="company_new_delivery.php">Solicitar Motoboy</a>
      <a class="btn" href="company_deliveries.php">Ver todas</a>
    </div>
  </div>

  <div class="card">
    <h1>Últimas entregas</h1>
    <?php if (!$deliveries): ?>
      <div class="notice">Nenhuma entrega ainda.</div>
    <?php else: ?>
      <table class="table">
        <thead>
          <tr>
            <th>#</th><th>Status</th><th>Motoboy</th><th>Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($deliveries as $d): ?>
            <tr>
              <td><?= (int)$d['id'] ?></td>
              <td><?= h($d['status']) ?></td>
              <td><?= h($d['motoboy_name'] ?? '-') ?></td>
              <td style="white-space:nowrap;">
                <a class="btn btn-primary" href="company_delivery_view.php?id=<?= (int)$d['id'] ?>">Ver</a>
                <a class="btn btn-ghost" href="track.php?t=<?= h($d['tracking_token']) ?>" target="_blank">Rastreio</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</div>
<?php render_footer(); ?>
