<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';

if (!empty($_SESSION['motoboy_id'])) {
  header('Location: motoboy_dashboard.php'); exit;
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');

  $st = $pdo->prepare("SELECT id, password_hash, name FROM motoboys WHERE email = ?");
  $st->execute([$email]);
  $u = $st->fetch();

  if ($u && password_verify($pass, $u['password_hash'])) {
    $_SESSION['motoboy_id'] = (int)$u['id'];
    $_SESSION['motoboy_name'] = $u['name'];
    header('Location: motoboy_dashboard.php'); exit;
  }
  $error = "Login inválido.";
}

render_header('Login Motoboy');
?>
<div class="card" style="max-width:520px; margin:0 auto;">
  <h1>Login Motoboy</h1>
  <?php if ($error): ?><div class="notice"><?= h($error) ?></div><?php endif; ?>
  <form method="post">
    <label>Email</label>
    <input name="email" type="email" required>

    <label>Senha</label>
    <input name="password" type="password" required>

    <div style="margin-top:12px; display:flex; gap:10px;">
      <button class="btn btn-primary" type="submit">Entrar</button>
      <a class="btn btn-ghost" href="index.php">Voltar</a>
    </div>
    <p class="small" style="margin-top:10px;">Demo: moto@teste.com / 123456</p>
  </form>
</div>
<?php render_footer(); ?>
