<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';

$token = (string)($_GET['t'] ?? '');
if ($token === '') { http_response_code(404); die("Token inválido."); }

$st = $pdo->prepare("
  SELECT d.*, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.tracking_token = ?
");
$st->execute([$token]);
$d = $st->fetch();

if (!$d) { http_response_code(404); die("Entrega não encontrada."); }

render_header('Rastreio');
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<div class="card">
  <h1>Rastreio da entrega #<?= (int)$d['id'] ?></h1>

  <div class="grid grid-2">
    <div>
      <div class="small">Status</div>
      <div class="badge warn" id="st"><?= h($d['status']) ?></div>

      <div style="height:10px"></div>

      <div class="small">Motoboy</div>
      <div class="notice" id="moto"><?= h($d['motoboy_name'] ?? 'Aguardando aceite...') ?></div>

      <div style="height:10px"></div>

      <div class="small">Coleta</div>
      <div class="notice"><?= h($d['pickup_address']) ?></div>

      <div class="small">Entrega</div>
      <div class="notice"><?= h($d['dropoff_address']) ?></div>

      <?php if (!empty($d['proof_photo_path'])): ?>
        <div style="height:10px"></div>
        <a class="btn btn-ghost" target="_blank" href="<?= h($d['proof_photo_path']) ?>">Ver foto da entrega</a>
      <?php endif; ?>
    </div>

    <div>
      <div class="small">Mapa (tempo real)</div>
      <div id="map" style="height:360px; border-radius:14px; border:1px solid rgba(255,255,255,.08);"></div>
      <div class="small" id="loc">Conectando...</div>
    </div>
  </div>
</div>

<script>
let map = L.map('map').setView([-3.7319, -38.5267], 12);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom:19}).addTo(map);

let marker = L.marker([-3.7319, -38.5267]).addTo(map);
let poly = L.polyline([], {}).addTo(map);
let points = [];

const es = new EventSource('sse_track.php?t=<?= h($token) ?>');
es.onmessage = (ev) => {
  const j = JSON.parse(ev.data);
  document.getElementById('st').textContent = j.status;
  document.getElementById('moto').textContent = j.motoboy_name || 'Aguardando aceite...';

  if(j.last_lat){
    const lat = parseFloat(j.last_lat), lng = parseFloat(j.last_lng);
    document.getElementById('loc').textContent = `${lat.toFixed(5)}, ${lng.toFixed(5)} • ${j.last_time}`;
    marker.setLatLng([lat,lng]);
    points.push([lat,lng]);
    if(points.length>1) poly.setLatLngs(points);
    map.setView([lat,lng], Math.max(map.getZoom(), 15));
  } else {
    document.getElementById('loc').textContent = 'Sem localização ainda.';
  }
};
</script>

<?php render_footer(); ?>
