<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

header('Content-Type: application/json');

$token = (string)($_GET['t'] ?? '');
if ($token === '') { echo json_encode(['ok'=>false]); exit; }

$st = $pdo->prepare("
  SELECT d.id, d.status, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.tracking_token = ?
");
$st->execute([$token]);
$d = $st->fetch();
if (!$d) { echo json_encode(['ok'=>false]); exit; }

$st = $pdo->prepare("
  SELECT lat, lng, created_at
  FROM delivery_locations
  WHERE delivery_id = ?
  ORDER BY id DESC
  LIMIT 1
");
$st->execute([(int)$d['id']]);
$loc = $st->fetch();

echo json_encode([
  'ok'=>true,
  'status'=>$d['status'],
  'motoboy_name'=>$d['motoboy_name'],
  'last_lat'=>$loc['lat'] ?? null,
  'last_lng'=>$loc['lng'] ?? null,
  'last_time'=>$loc['created_at'] ?? null
]);
