<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_motoboy();

header('Content-Type: application/json');

$motoboyId = (int)$_SESSION['motoboy_id'];
$deliveryId = (int)($_POST['delivery_id'] ?? 0);

if ($deliveryId <= 0) { echo json_encode(['ok'=>false,'error'=>'ID inválido']); exit; }

$st = $pdo->prepare("SELECT id FROM deliveries WHERE id=? AND motoboy_id=?");
$st->execute([$deliveryId, $motoboyId]);
if (!$st->fetch()) { echo json_encode(['ok'=>false,'error'=>'Entrega não pertence a você']); exit; }

if (empty($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
  echo json_encode(['ok'=>false,'error'=>'Arquivo inválido']); exit;
}

$maxBytes = 3 * 1024 * 1024; // 3MB
if ($_FILES['photo']['size'] > $maxBytes) {
  echo json_encode(['ok'=>false,'error'=>'Arquivo muito grande (max 3MB)']); exit;
}

$finfo = new finfo(FILEINFO_MIME_TYPE);
$mime = $finfo->file($_FILES['photo']['tmp_name']);
$allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/webp'=>'webp'];

if (!isset($allowed[$mime])) {
  echo json_encode(['ok'=>false,'error'=>'Formato não permitido']); exit;
}

$ext = $allowed[$mime];
$dir = __DIR__ . '/../uploads/proofs/';
if (!is_dir($dir)) mkdir($dir, 0755, true);

$name = 'proof_' . $deliveryId . '_' . time() . '.' . $ext;
$path = $dir . $name;

if (!move_uploaded_file($_FILES['photo']['tmp_name'], $path)) {
  echo json_encode(['ok'=>false,'error'=>'Falha ao salvar arquivo']); exit;
}

$rel = 'uploads/proofs/' . $name;

$st = $pdo->prepare("UPDATE deliveries SET proof_photo_path=? WHERE id=? AND motoboy_id=?");
$st->execute([$rel, $deliveryId, $motoboyId]);

echo json_encode(['ok'=>true, 'path'=>$rel]);
