<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];
$deliveryId = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("
  SELECT d.*, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id=d.motoboy_id
  WHERE d.id=? AND d.company_id=?
");
$st->execute([$deliveryId, $companyId]);
$d = $st->fetch();
if(!$d){ http_response_code(404); die("Entrega não encontrada."); }

$ok=null; $err=null;
if($_SERVER['REQUEST_METHOD']==='POST'){
  $rating = (int)($_POST['rating'] ?? 0);
  $comment = trim((string)($_POST['comment'] ?? ''));

  if($d['status'] !== 'delivered') $err = "Só é possível avaliar após entregue.";
  else if($rating < 1 || $rating > 5) $err = "Nota inválida.";
  else{
    $st = $pdo->prepare("UPDATE deliveries SET rating=?, rating_comment=? WHERE id=? AND company_id=?");
    $st->execute([$rating, ($comment!==''?$comment:null), $deliveryId, $companyId]);
    $ok = "Avaliação salva!";
    $d['rating'] = $rating;
    $d['rating_comment'] = $comment;
  }
}

render_header("Avaliar entrega #{$deliveryId}");
?>
<div class="card">
  <h1>Avaliar entrega #<?= (int)$deliveryId ?></h1>
  <p class="small">Motoboy: <?= h($d['motoboy_name'] ?? '-') ?></p>

  <?php if($ok): ?><div class="notice"><?= h($ok) ?></div><?php endif; ?>
  <?php if($err): ?><div class="notice"><?= h($err) ?></div><?php endif; ?>

  <form method="post">
    <label>Nota (1 a 5)</label>
    <select name="rating" required>
      <?php for($i=1;$i<=5;$i++): ?>
        <option value="<?= $i ?>" <?= ((int)($d['rating'] ?? 0) === $i ? 'selected' : '') ?>><?= $i ?></option>
      <?php endfor; ?>
    </select>

    <label>Comentário (opcional)</label>
    <input name="comment" value="<?= h((string)($d['rating_comment'] ?? '')) ?>">

    <div style="margin-top:12px; display:flex; gap:10px;">
      <button class="btn btn-primary" type="submit">Salvar</button>
      <a class="btn" href="company_deliveries.php">Voltar</a>
    </div>
  </form>
</div>
<?php render_footer(); ?>
