<?php
// layout.php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';

function render_header(string $title): void {
  ?>
  <!doctype html>
  <html lang="pt-br">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?= h($title) ?></title>
    <link rel="stylesheet" href="style.css">
  </head>
  <body>
    <div class="topbar">
      <div class="container topbar-inner">
        <div class="brand">APP ENTREGADOR</div>
        <div class="top-actions">
          <a class="btn btn-ghost" href="index.php">Início</a>
          <?php if (!empty($_SESSION['company_id']) || !empty($_SESSION['motoboy_id'])): ?>
            <a class="btn btn-danger" href="logout.php">Sair</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="container">
  <?php
}

function render_footer(): void {
  ?>
    </div>
    <div class="footer">
      <div class="container">MVP PHP + MySQL • <?= date('Y') ?></div>
    </div>
  </body>
  </html>
  <?php
}
