<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

$token = (string)($_GET['t'] ?? '');
if ($token === '') { echo "event: error\ndata: {}\n\n"; exit; }

// Em shared hosting, SSE é melhor com conexões curtas e reconexão automática do browser.
// Este loop dura ~2 minutos e termina; o EventSource reconecta sozinho.
for ($i=0; $i<120; $i++) {
  $st = $pdo->prepare("SELECT id, status, motoboy_id FROM deliveries WHERE tracking_token=?");
  $st->execute([$token]);
  $d = $st->fetch();
  if(!$d){ echo "event: error\ndata: {}\n\n"; @ob_flush(); @flush(); break; }

  $motoboyName = null;
  if (!empty($d['motoboy_id'])) {
    $st = $pdo->prepare("SELECT name FROM motoboys WHERE id=?");
    $st->execute([(int)$d['motoboy_id']]);
    $motoboyName = $st->fetchColumn() ?: null;
  }

  $st = $pdo->prepare("
    SELECT id, lat, lng, created_at
    FROM delivery_locations
    WHERE delivery_id=?
    ORDER BY id DESC LIMIT 1
  ");
  $st->execute([(int)$d['id']]);
  $loc = $st->fetch();

  $payload = [
    'status'=>$d['status'],
    'motoboy_name'=>$motoboyName,
    'last_lat'=>$loc['lat'] ?? null,
    'last_lng'=>$loc['lng'] ?? null,
    'last_time'=>$loc['created_at'] ?? null,
  ];

  echo "data: " . json_encode($payload) . "\n\n";
  @ob_flush(); @flush();
  sleep(2);
}
